
write "zxkbtest.com"  ; tell winApe to which output file to write

;**** set application area and run address here ****

application equ #6000 ; can be address from #4000 up to #FF00

appl_run equ #6000 ; after the program is loaded, execution starts here

use_interrupt equ 0

READ "zx_incl.asm"  ; this include is required to start the Spectrum program from CP/M

;*** Manual ***
;
; This program can be assembled with WinApe (Amstrad simulator and assembler) on a PC.
; When you start winApe, it wants to install "DirectPlay", but you can skip that.
; The assembler delivers a ".com" file.
;
; On the Isetta computer, start the SymShell by double clicking on it's icon.
; If you like, select a full screen with the "full" command.
; Change the directory (with CD command) to the directory where the .com file and cpvm.com are.
;
; Then type "cpvm" to start the CP/M operating system,
;
; and in CP/M, type the name of the .com file, to start it.
;

;**************** ZX Spectrum application  ****************
  
  org application
  
; This application, "zxkbtest" will show on the screen how keyboard events 
; are presented to the ZX Spectrum program.
;
; A ZX spectrum has a keyboard matrix with 40 keys, in 8 groups of 5.
; With a "IN a,(#FE)" instruction, with the group code in register B, you
; get 5 bits returned, telling which keys are active in this group (active = 0).
;
; The Isetta computer receives messages from the PS/2 keyboard. These are called
; scancodes. The include file first translates the scancode to an ASCII value, in
; the function "readkey". Whenever the input port #FE is read, the ascii value
; is converted to a bit in the ZX Spectrum keyboard matrix, and the required 
; keyboard row is returned.
;
; On the screen you see the keyboard matrix, with a pressed key in RED.
; You also see the ascii/CP1252 value and the ps/2 scancode of the key, and an
; indicator C (when capslock is active) or N (when numlock is active).
;
; After "lang:" you see the code for the current selected ps/2 keyboard language:
;   00 (default English US)
;   44 Deutsch (German)
;   45 English (UK)
;   46 French
;   53 Spanish
; The keyboard language can be selected in the symbOS operating system.
;  
; The application also demonstrates the ZX spectrum screenmode (32 x 24 characters)
;
  
; 15-6-2024 init attributes to a neutral value
 ld hl,zx_attribs ; 5800
 ld d,24
zx_pattrn2: 
 ld b,32
zx_pattrn4:  ;; all chars of a certain line, same color
 ld (hl),#44  ; write color,  bright green on black
 inc hl
 djnz zx_pattrn4
 dec d
 jr nz,zx_pattrn2

; Have the Spectrum colors in upper right row

 ld hl,zx_attribs+22
 ld a,#40 + #12 ; bright RED
 ld (hl),a
 inc hl
 ld (hl),a
 inc hl 
 ld a,#40 + #36 ; bright YELLOW (red+green)
 ld (hl),a
 inc hl
 ld (hl),a
 inc hl 
 ld a,#40 + #24 ; bright GREEN
 ld (hl),a
 inc hl
 ld (hl),a
 inc hl 
 ld a,#40 + #09 ; bright BLUE
 ld (hl),a
 inc hl
 ld (hl),a 
 
 ; clear screen
 ld hl,#4000
 ld de,#4001
 ld (hl),0
 ld bc,#1800
 ldir
 
 ld hl,#4040
 ld (zx_pos),hl
 ld hl,m_welcome ; zx_pos is at 4020
 call prline


; This testloop does repeatedly IN A,(FE) and displays the 
; pressed keys on the screen.
; This will test if the ZX Spectrum software can read keys properly.


testloop:
 ; if ascii changed, print it
 ld a,(kb_ascii)
 ld hl,kb_ascii_copy
 cp (hl)
 jr z,no_asc_change
 ld (hl),a 
  ; go print ascii
 ld hl,#5020
 ld (zx_pos),hl
 ld hl,m_ascii ; message
 call prline 
 ld a,(kb_ascii)
 call prbyte 
 ld a,#20
 call chout
 ld a,(kb_ascii) 
 cp #20
 jr nc,no_ctl
 ; ctl char
 ld a,#20
no_ctl:
 call chout 
 ; display keyboard language  29-1-2026
 ld hl,m_lang
 call prline
 ld hl,#04F1 ; kb language location
 in a,(port_io_bank1)
 call prbyte
 
no_asc_change:
 ld hl,#5060
 ld (zx_pos),hl
 ld hl,m_scan ; message
 call prline 
 ld a,(rk_prefix)  ; print prefix byte (or 00)
 call prbyte
 ld a,(rk_scancode) ; print scancode
 call prbyte 
 
;no_scan_change: 
 ld hl,#50A0
 ld (zx_pos),hl
 ld hl,rk_flags
 bit 0,(hl) ; check capslock flag
 ld a,"C"
 jr nz,flag_capslock
 ld a," " 
flag_capslock: 
 call chout
 ld a," "
 call chout
 bit 1,(hl) ; check numlock flag
 ld a,"N"
 jr nz,flag_numlock
 ld a," " 
flag_numlock: 
 call chout
 
 
 call pr_kb ; print the keyboard impression, might change along the way

 ld de,key_table
 ld hl,#5901  ; color position of bit 0 in right groups
 ld c,4
nextrowleft:
 push hl
 ld a,(de) ; get code F7, FB etc
 ;call prbyte
 ld b,a
 xor a ; check if a is really filled
 inc de
 inc de
 in a,(#FE)  ; read ZX keyboard
 ld b,5 ; 5 bits
leftbit: 
 rra
 ;ld (hl),#42    ; color_on (red) (not here. If interrupt follows, you see a short red blink)
 jr nc,left_on
 ld (hl),#07    ; color off (gray)
 jr left_nxt
left_on: 
 ld (hl),#42    ; color_on (red)
left_nxt:  
 inc hl
 inc hl
 djnz leftbit
 pop hl
 ;ld a," "
 ;call chout
 ld a,l
 add a,#20
 ld l,a
 dec c
 jr nz,nextrowleft
 
 ld hl,#5915 ; color pos of bit 0 in right groups
 ld c,4
nextrowright:
 push hl
 ld a,(de) ; get code EF, DF etc
 ld b,a
 inc de
 inc de
 in a,(#FE)  ; read ZX keyboard
 ;read bits here, dec hl
 ld b,5
rightbit:
 rra
 ;ld (hl),#42    ; color_on (red) (not here. If interrupt follows, you see a short red blink)
 jr nc,right_on
 ld (hl),#07    ; color off (gray)
 jr right_nxt
right_on: 
 ld (hl),#42    ; color_on (red)
right_nxt:  
 dec hl
 dec hl
 djnz rightbit
 pop hl
 ld a,l
 add a,#20
 ld l,a 
 dec c
 jr nz,nextrowright 
 
 jp testloop  ; stay in this loop

pr_kb:
 ld ix,tx_row0
 ld de,#4800  ; middle section of screen
 ld c,23
 call pmess_row
 ld ix,tx_row1
 ld de,#4820
 ld c,23
 call pmess_row
 ld ix,tx_row2
 ld de,#4840 
 ld c,23
 call pmess_row
 ld ix,tx_row3
 ld de,#4860 
 ld c,23
 call pmess_row 
 ret

pmess_row:
 ld hl,k_row7+1
 bit 1,(hl)  ; is symbol shift active
 jr nz,k_nosym ; jp if not active (1)
 exx
 ld de,23
 add ix,de
 exx

k_nosym: 
 jp pmess
  

tx_row0:
  db " 1 2 3 4 5   6 7 8 9 0 "
  db " ! @ # $ %   & ' ( ) _ " ; also row0, the symbols

tx_row1:  
  db " q w e r t   y u i o p "
  db " C C C < >   [ ] ? ; ",#22,#20 ; also row1, the symbols. #22='"'


tx_row2: 
  db " a s d f g   h j k l < "
  db " ~ | ",#5C," { }   ^ - + = < " ;  symbols  #5C = "\"

tx_row3: 
  db " ^ z x c v   b n m * _ "
  db " ^ : # ? /   * , . * _ " ;  symbols  
    

kb_ascii_copy db 0

m_welcome db "Isetta ZX spectrum kb test",0
m_ascii db "CP1252: ",0
m_scan db "PS/2 scancode: ",0
m_lang db "  lang: ",0


;**** character output routines ****

 ; Note that there is no automatic jump to a next line
 ; And also a CR will not bring you to the next line.
 ; Put the screen address in "zx_pos"

;PRBYTE print a byte (in hex)
prbyte:
 call pb1
pb1:
 rrca
 rrca
 rrca
 rrca
 push af
 and #0F
 cp #0A
 jr c,pbdigit ; jp if value was 0-9
 add a,#07  ; convert 10-15 to A-F
pbdigit: add a,#30
 call chout
 pop af
 ret
 
chout: 
 push hl
 push de
 ld de,(zx_pos)
 call PRINTCHAR
 ld hl,(zx_pos) 
 inc hl
 ld (zx_pos),hl
 pop de
 pop hl 
 ret
 
prline:  ; 7-12-2025. Print a zero-terminated string, (address in HL)
 ld a,(hl)
 or a
 ret z 
 push hl
 push de
 ld de,(zx_pos)
 call PRINTCHAR
 ld hl,(zx_pos) 
 inc hl
 ld (zx_pos),hl
 pop de
 pop hl
 inc hl
 jr prline 

; Routines PMESS and PRINTCHAR are copied from Manic Miner
; IX Address of the message
; C Length of the message
; DE Display file address
PMESS:
  LD A,(IX+0)             ; Collect a character from the message
  CALL PRINTCHAR          ; Print it
  INC IX                  ; Point IX at the next character in the message
  INC E                   ; Point DE at the next character cell (subtracting 8
  LD A,D                  ; from D compensates for the operations performed by
  SUB 8                   ; the routine at PRINTCHAR)
  LD D,A                  ;
  DEC C                   ; Have we printed the entire message yet?
  JR NZ,PMESS             ; If not, jump back to print the next character
  RET

; Print a single character
; Used by the routine at PMESS.
; A ASCII code of the character
; DE Display file address
PRINTCHAR:
  LD H,7                  ; Point HL at the bitmap for the character (in the
  LD L,A                  ; ROM)
  SET 7,L                 ;
  ADD HL,HL               ;
  ADD HL,HL               ;
  ADD HL,HL               ;
  LD B,8                  ; There are eight pixel rows in a character bitmap
PRINTCHAR_0:  
  LD A,(HL)               ; Copy the character bitmap to the screen 
  LD (DE),A               ; 
  INC HL                  ;
  INC D                   ;
  DJNZ PRINTCHAR_0        ;
  RET
  
 ;******  the label "application_end" is required  ******
 
 application_end 
 
 end
 
 